--require( "scripts/gameparams.lua" );


function GetSectionForLoading()
    return SectionForLoading;
end
function GetSectionForUnloading()
    return SectionForUnloading;
end

function GetScriptRunAfterWork()
    return ScriptRunAfterWork;
end


if( StartUpLoading == true)then
    SectionForLoading = {"normal"};   
    if(  gGlobalPlayerInfo and gGlobalPlayerInfo.gCurrentFarm 
        and gGlobalPlayerInfo.gCurrentFarm>0) then
        SectionForLoading[2] = "farm_"..gGlobalPlayerInfo.gCurrentFarm;    
    end;        

    StartUpLoading = nil;
end
    

MakeDialog
{   name="theloading",
    Loader
    {
        SectionForLoading = GetSectionForLoading();
        SectionForUnloading = GetSectionForUnloading();
        ScriptRunAfterWork  = GetScriptRunAfterWork();
    
        SpritePlayer
        { 
            name="backgroundimage",
            --image="backgrounds/fullscreendialog.jpg",   --loading",
            x=0,
            y=0,
            w=800,
            h=600,
            BgColor = Color(102,227,249,255);
            LuaScript = "OnTimer()";
            Sprite = "sprites/loading_sw.xml";
            --Frenzy= 30;           
            
            Text
            {
                font = MyFont,
                name = "loading_label",
                font = { standardFont, 35, BlackColor},
                x=350,y=90,w=400,h=300,
                flags = kVAlignCenter,
                label = "loading";
            };            
            
            ProgressBar
            {
                Background = "slider/back",
                Foreground = "slider/front",
                name = "LoadingProgressing",
                x = 240,
                y = 440,
            }
        }
    }
}

local faza = 0;

function OnTimer()
    faza = faza + 1;
    if faza > 3 then faza = 0; end
    local s = "";
    for i = 0, faza do
        s = s..".";
    end
    SetLabel( "loading_label", GetString("loading", s));
    
end
